function smartDate(dateForm,tickDays)
%smartDate(dateForm,[tickDays]).m
%
%Script to allow on-the-fly updating of dateticks on time series graphs,
%useful when used with "smartLink" to link all axis on the current figure
%as well.
%
% dateForm added to allow personalised date formats (Default is "dd/mm/yy")
%
% optional "tickDays" specifies spacing between ticks in days
%
%Ben K 2008

if nargin<2; tickDays=[]; end
if nargin==0; dateForm='dd/mm/yy'; end
set(gcf,'renderermode','manual','renderer','zbuffer','WindowButtonMotionFcn','');
%myDateTick;

h = zoom(gcf); 
hFig=get(h,'FigureHandle');
if isempty(get(hFig,'Tag'))
    set(hFig,'Tag',dateForm);
else
    warning('Overwriting figure tag with "dateForm"')
    set(hFig,'Tag',dateForm);
end
if isempty(get(hFig,'userData'))
    set(hFig,'userData',tickDays);
    else
    warning('Overwriting figure user data with "tickDays"')
    set(hFig,'userData',tickDays);
end
set(h,'ActionPostCallback',@myDateTick);
set(h,'Enable','on');

h2 = pan(gcf); 
set(h2,'ActionPostCallback',@myDateTick);

set(h2,'Enable','on');
shg;

function myDateTick(obj,evd)
objTag = get(obj,'Tag');
objDat= get(obj,'userData');
if isempty(objDat)
    datetick('x',objTag,'KeepLimits');
else
    xlims=xlim;
    set(gca,'xtick',ceil(xlims(1)):objDat:floor(xlims(2)));
    datetick('x',objTag,'KeepLimits','KeepTicks');
end

