function sta=read_staFile(dirIn,staSetupfile)
%
% sta=read_staFile(dirIn,staSetupfile)
%
% read station file produced by selfe v3...
% dirIn gives directory to 'staout_1' etc files
% staSetupFile optional, 
% 
% ben k 2011
%

dirIn=[safeDir(dirIn) filesep];
if nargin<2, staSetupfile=[dirIn 'station.in']; end
staFiles=dir([dirIn 'staout_*']);

if ~isempty(staSetupfile)
    sta=read_setup(staSetupfile);
else
    % get flag infro from file names
    sta.varFlags=zeros(1,9);
    for i=1:length(staFiles)
        b=regexp(staFiles(i).name,'[_]+','split');
        if isnumber(b{2})
            sta.varFlags(str2num(b{2}))=1;
        end
    end
end

sta.varNames={'elev','airPress','wind_x','wind_y','T','S','u','v','w'};

count=0;
for flag=sta.varFlags
    count=count+1;
    if flag==1
        fid=fopen([dirIn 'staout_' num2str(count)]);
        dat=fscanf(fid,'%g');
        dat=reshape(dat,(sta.numStations+1),length(dat)/(sta.numStations+1))';
        if ~isfield(sta,'time')
            sta=setfield(sta,'time',dat(:,1));
        end
        sta=setfield(sta,sta.varNames{count},dat(:,2:end));
        fclose(fid);
    end
end
fclose('all')

function out=read_setup(staSetupfile)
%
% read in station info
%

fid=fopen(staSetupfile);
if fid==-1, error(['File ' staSetupfile ' was not found.']); end

s='blah';
count=0;
out.numStations=10;

while s~=-1
    count=count+1;
    if count>(out.numStations+2), break, end
    s=fgetl(fid);
    tmp=str2num(s);
    
    if count==1
        out.varFlags=tmp;
    elseif count==2
        out.numStations=tmp;
        out.StationData=zeros(out.numStations,4);
    else
        out.StationData(count-2,:)=tmp;
    end
end

fclose(fid);
        
        
    

    
