#! /usr/bin/env python
# -*- coding: utf-8 -*-

#
# Authors: Alberto Azevedo, Andre Fortunato, Laboratorio Nacional de Engenharia Civil
import os,sys
wdir=os.getcwd()
paths=['/home/afortuna/bin_py',wdir]
for i in paths:
	sys.path.append(i)
	
import matplotlib.pyplot as plt
import matplotlib.colors as colors
import numpy as np
import scipy as sp

### Functions 
############################################################

def morpho_cmap(zmin,zmax,MinLev,MaxLev,MinTick=-20.,MaxTick=20.,Out_zero=0.,dLev=5,dTick=5,reverse=False):
	"""
	Format: 
	cbar,levs,levs_txt,contourLines = GR.morpho_cmap(zmin,zmax,MinLev,MaxLev,MinTick,MaxTick,Out_zero=0.,dLev=5,dTick=5,reverse=False)
	
	Inputs:
			zmin,zmax = valores maximos e minimos dos dados 
			MinLev,MaxLev = valores maximos e minimos das linhas de contour
			MinTick,MaxTick = valores maximos e minimos da barra de cores
			Out_zero= centro dos dados (por defeito=0). 
			dLev=5 intervalo para os valores da colorbar
			dTick=5 intervalo para os valores dos contours 
			reverse = True para inverter as cores da palete (por defeito = False)
	
	Outputs:
			cbar= colormap
			levs= niveis dos dados (256 elementos)
			levs_txt= niveis para a colorbar
			contourLines= niveis para os contours a desenhar
			
	Example: 
			cbar,levs,levs_txt,contourLines = GR.morpho_cmap_test(-10,20,-10,20,-5,5,Out_zero=0.,dLev=2,dTick=5,reverse=False)
	"""
	import matplotlib.colors as colors
	
	zero = (Out_zero-zmin)/(zmax-zmin)
	levs = np.linspace(zmin,zmax+0.001,256)
	contourLines = np.arange(MinLev,MaxLev+0.001,dLev)
	
	if MinTick < zmin: 
		MinTick=zmin
	if MaxTick > zmax:
		MaxTick=zmax
	levs_txt= np.arange(MinTick,MaxTick+0.001,dTick)
	
	cvals=[(0.,0.02,0.53),(0.,0.047,0.533),(0.,0.075,0.529),
			(0.004,0.169,0.549),(0.004,0.169,0.549),(0.031,0.247,0.569),
			(0.024,0.31,0.58),(0.004,0.361,0.573),(0.027,0.431,0.596),
			(0.039,0.518,0.588),(0.392,0.608,0.533),(0.678,0.71,0.451),
			(0.969,0.78,0.388),(1.,0.992,0.792),(0.996,0.992,0.80),(1.,0.992,0.85)]

	if not reverse:
		tlt0=np.linspace(0.,zero,11)
		tgt0=np.linspace(zero,1.,5)
		t1,t2,t3,t4,t5,t6,t7,t8,t9=tlt0[1:10]
		t11,t12,t13=tgt0[1:4]
		cdictOB  = {'red':  [(0.0, cvals[0][0] , cvals[0][0] ),
                        (t1	 , cvals[1][0] , cvals[1][0] ),
                        (t2  , cvals[2][0] , cvals[2][0] ),
                        (t3  , cvals[3][0] , cvals[3][0] ),
                        (t4  , cvals[4][0] , cvals[4][0] ),
                        (t5  , cvals[5][0] , cvals[5][0] ),
                        (t6  , cvals[6][0] , cvals[6][0] ),
                        (t7  , cvals[7][0] , cvals[7][0] ),
                        (t8  , cvals[8][0] , cvals[8][0] ),
                        (t9  , cvals[9][0] , cvals[9][0] ),
                        (zero, cvals[10][0] , cvals[10][0] ),
                        (t11 , cvals[11][0] , cvals[11][0] ),
                        (t12 , cvals[12][0] , cvals[12][0] ),
                        (t13 , cvals[13][0] , cvals[13][0] ),
                        (1.0 , cvals[14][0] , cvals[14][0] )],
              'green':  [(0.0, cvals[0][1] , cvals[0][1] ),
                        (t1	 , cvals[1][1] , cvals[1][1] ),
                        (t2  , cvals[2][1] , cvals[2][1] ),
                        (t3  , cvals[3][1] , cvals[3][1] ),
                        (t4  , cvals[4][1] , cvals[4][1] ),
                        (t5  , cvals[5][1] , cvals[5][1] ),
                        (t6  , cvals[6][1] , cvals[6][1] ),
                        (t7  , cvals[7][1] , cvals[7][1] ),
                        (t8  , cvals[8][1] , cvals[8][1] ),
                        (t9  , cvals[9][1] , cvals[9][1] ),
                        (zero, cvals[10][1] , cvals[10][1] ),
                        (t11 , cvals[11][1] , cvals[11][1] ),
                        (t12 , cvals[12][1] , cvals[12][1] ),
                        (t13 , cvals[13][1] , cvals[13][1] ),
                        (1.0 , cvals[14][1] , cvals[14][1] )],
              'blue':  [(0.0, cvals[0][2] , cvals[0][2] ),
                        (t1	 , cvals[1][2] , cvals[1][2] ),
                        (t2  , cvals[2][2] , cvals[2][2] ),
                        (t3  , cvals[3][2] , cvals[3][2] ),
                        (t4  , cvals[4][2] , cvals[4][2] ),
                        (t5  , cvals[5][2] , cvals[5][2] ),
                        (t6  , cvals[6][2] , cvals[6][2] ),
                        (t7  , cvals[7][2] , cvals[7][2] ),
                        (t8  , cvals[8][2] , cvals[8][2] ),
                        (t9  , cvals[9][2] , cvals[9][2] ),
                        (zero, cvals[10][2] , cvals[10][2] ),
                        (t11 , cvals[11][2] , cvals[11][2] ),
                        (t12 , cvals[12][2] , cvals[12][2] ),
                        (t13 , cvals[13][2] , cvals[13][2] ),
                        (1.0 , cvals[14][2] , cvals[14][2] )]}
	else:
		cvals.reverse()
		tlt0=np.linspace(0.,zero,5)
		tgt0=np.linspace(zero,1.,11)
		t1,t2,t3=tlt0[1:4]
		t5,t6,t7,t8,t9,t10,t11,t12,t13=tgt0[1:10]
		cdictOB  = {'red':  [(0.0, cvals[0][0] , cvals[0][0] ),
		                (t1	 , cvals[1][0] , cvals[1][0] ),
                        (t2  , cvals[2][0] , cvals[2][0] ),
                        (t3  , cvals[3][0] , cvals[3][0] ),
                        (zero  , cvals[4][0] , cvals[4][0] ),
                        (t5  , cvals[5][0] , cvals[5][0] ),
                        (t6  , cvals[6][0] , cvals[6][0] ),
                        (t7  , cvals[7][0] , cvals[7][0] ),
                        (t8  , cvals[8][0] , cvals[8][0] ),
                        (t9  , cvals[9][0] , cvals[9][0] ),
                        (t10, cvals[10][0] , cvals[10][0] ),
                        (t11 , cvals[11][0] , cvals[11][0] ),
                        (t12 , cvals[12][0] , cvals[12][0] ),
                        (t13 , cvals[13][0] , cvals[13][0] ),
                        (1.0 , cvals[14][0] , cvals[14][0] )],
              'green':  [(0.0, cvals[0][1] , cvals[0][1] ),
                        (t1	 , cvals[1][1] , cvals[1][1] ),
                        (t2  , cvals[2][1] , cvals[2][1] ),
                        (t3  , cvals[3][1] , cvals[3][1] ),
                        (zero  , cvals[4][1] , cvals[4][1] ),
                        (t5  , cvals[5][1] , cvals[5][1] ),
                        (t6  , cvals[6][1] , cvals[6][1] ),
                        (t7  , cvals[7][1] , cvals[7][1] ),
                        (t8  , cvals[8][1] , cvals[8][1] ),
                        (t9  , cvals[9][1] , cvals[9][1] ),
                        (t10, cvals[10][1] , cvals[10][1] ),
                        (t11 , cvals[11][1] , cvals[11][1] ),
                        (t12 , cvals[12][1] , cvals[12][1] ),
                        (t13 , cvals[13][1] , cvals[13][1] ),
                        (1.0 , cvals[14][1] , cvals[14][1] )],
              'blue':  [(0.0, cvals[0][2] , cvals[0][2] ),
                        (t1	 , cvals[1][2] , cvals[1][2] ),
                        (t2  , cvals[2][2] , cvals[2][2] ),
                        (t3  , cvals[3][2] , cvals[3][2] ),
                        (zero  , cvals[4][2] , cvals[4][2] ),
                        (t5  , cvals[5][2] , cvals[5][2] ),
                        (t6  , cvals[6][2] , cvals[6][2] ),
                        (t7  , cvals[7][2] , cvals[7][2] ),
                        (t8  , cvals[8][2] , cvals[8][2] ),
                        (t9  , cvals[9][2] , cvals[9][2] ),
                        (t10 , cvals[10][2] , cvals[10][2] ),
                        (t11 , cvals[11][2] , cvals[11][2] ),
                        (t12 , cvals[12][2] , cvals[12][2] ),
                        (t13 , cvals[13][2] , cvals[13][2] ),
                        (1.0 , cvals[14][2] , cvals[14][2] )]}
	cbar = colors.LinearSegmentedColormap('my_colormap',cdictOB,256)
	return cbar,levs,levs_txt,contourLines

############################################################

def read_bpt(filein):
        fid=open(filein,'r')
        text=fid.readlines()
        fid.close()
        filename=filein
        nodes=int(text[1])
        nxyz_aux=[]
        for i in text[2:]:
            line=i.split()
            if len(line)==4:
                nxyz_aux.append([float(i.split()[0]),float(i.split()[1]),float(i.split()[2]),float(i.split()[3])])
        nxyz=np.array(nxyz_aux)
        return [filename,nodes,nxyz]

############################################################

def NorthArrow_i(ax,xc=0.08,yc=0.90):
        """ax=plt.subplot(111)"""
        arrow_x=[xc-0.02,xc,xc+0.02,xc,xc-0.02]
        arrow_y=[yc-0.055,yc+0.09,yc-0.055,yc-0.04,yc-0.055]
        plt.plot(arrow_x,arrow_y,'-w',transform=ax.transAxes)
        plt.plot(xc,yc,'k',marker='o',markerfacecolor='w', markersize=20,transform=ax.transAxes)
        plt.text(xc,yc,'N',
                horizontalalignment='center',
                verticalalignment='center',
                transform = ax.transAxes,size='x-large',color='k',
                fontweight='heavy',fontstyle='italic')
        return None
############################################################

def NorthArrow(ax,xc=0.08,yc=0.90):
        """ax=plt.subplot(111)"""
        arrow_x=[xc-0.02,xc,xc+0.02,xc,xc-0.02]
        arrow_y=[yc-0.055,yc+0.09,yc-0.055,yc-0.04,yc-0.055]
        plt.plot(arrow_x,arrow_y,'-k',transform=ax.transAxes)
        plt.plot(xc,yc,'k',marker='o',markerfacecolor='k', markersize=20,transform=ax.transAxes)
        plt.text(xc,yc,'N',
                horizontalalignment='center',
                verticalalignment='center',
                transform = ax.transAxes,size='x-large',color='w',
                fontweight='heavy',fontstyle='italic')
        return None

############################################################

def read_stations(filein):
    fid=open(filein,'r')
    nodes=int(fid.readline())

    stations_aux=[]
    for i in range(nodes):
	line=fid.readline()
        line=line.split()
        if len(line)==3:
            stations_aux.append([line[0],float(line[1]),float(line[2])])
	else:
	    print ' Error in file'+filein
	    exit

    fid.close()
    stations = np.array(stations_aux)
    return [nodes,stations]

############################################################

def read_mgrid(filein):
# read a mixed grid (tris and quads)
    fid=open(filein,'r')
    filename=fid.readline()
    el_no=fid.readline()
    el_aux=int(el_no.split()[0])
    el=np.array(el_aux)
    nodes_aux=int(el_no.split()[1])
    nodes=np.array(nodes_aux)
       
    xyz_aux=[]
    for i in xrange(nodes):
        line=fid.readline()
        line=line.split()
        xyz_aux.append([np.float(line[1]),np.float(line[2]),np.float(line[3])])
    xyz=np.array(xyz_aux)
            
    npel_aux=[]
    ncon_aux=[]
    for j in xrange(el):
        line2=fid.readline()
        line2=line2.split()
	npel_aux.append(int(line2[1]))
	if int(line2[1]) == 3:
            ncon_aux.append([int(line2[2]),int(line2[3]),int(line2[4])])
	elif int(line2[1]) == 4:
            ncon_aux.append([int(line2[2]),int(line2[3]),int(line2[4]),int(line2[5])])
        
    npel=np.array(npel_aux)
    ncon=np.array(ncon_aux)
    
    
#    Open Boundaries
    line=fid.readline()
    if len(line) == 0:
        bnd_segm=[]
        return filename,el,nodes,xyz,npel,ncon,bnd_segm 
    else: 
        line=line.split()
        nopen=int(line[0])
    
        line=fid.readline()
        line=line.split()
        nd_open=int(line[0])
        bnd_segm=[]     
    
        for i in xrange(nopen):
            #        print i
            line=fid.readline()
            line=line.split()
            ibnd=int(line[0])

            bnd_open=np.zeros((ibnd,2),dtype=np.int32)
            c=0
            for j in xrange(ibnd):
                line=fid.readline()
                line=line.split()
                ibnd=int(line[0])
                bnd_open[c,0]=ibnd
                bnd_open[c,1]=0
#                print bnd_open[c]
                c+=1
            bnd_segm.append(bnd_open)

#   Land Boundaries
        line=fid.readline()
        line=line.split()
        nland=int(line[0])
    
        line=fid.readline()
        line=line.split()
        nd_land=int(line[0])
    
        for i in xrange(nland):
#            print i
            line=fid.readline()
            line=line.split()
            ibnd=int(line[0])
            itype=int(line[1])
            if itype==0:
                bnd_land=np.zeros((ibnd,2),dtype=np.int32)
            else:
                bnd_land=np.zeros((ibnd+1,2),dtype=np.int32)
            
            c=0
            for j in xrange(ibnd):
                line=fid.readline()
                line=line.split()
              
                ibnd=int(line[0])
                bnd_land[c,0]=ibnd
                bnd_land[c,1]=itype
#                print bnd_land[c]
                c+=1
        
            if itype==1:
                bnd_land[-1,0]=bnd_land[0,0]
                bnd_land[-1,1]=bnd_land[0,1]
            
            bnd_segm.append(bnd_land)
        return filename,el,nodes,xyz,npel,ncon,bnd_segm 

############################################################

def interpol1d(xsize,y=np.array([])):
	import scipy.interpolate as spi
	x = np.arange(len(y))
	f = spi.interp1d(x, y)
	xnew = np.linspace(0,len(y)-1, np.int(xsize))
	ynew = f(xnew)   # use interpolation function returned by `interp1d`
	return ynew

############################################################

def text_labels(array_in=np.array([]),form='10.2e'):
	list_out=[]
	for i in array_in:
		list_out.append(str(format(i,form)))
	return list_out

############################################################

def read_parms(filein):
#   read a list of parameters from a file. The parameters are specified below.
#   The parameters in the file do not need to be ordered.
#   Lines starting with '#' are comments.
#   grid is a grid file
#   stations is a build points file
#   stationfile has the number of stations in line one (same as in stations), then the names and x,y offsets
    
    params= {}
#   default parameters, if any
    params['grid'] 	= 'hgrid.gr3'
    params['savefig'] 	= '0'
    params['showgrid'] 	= '1'
    params['palette'] 	= '-3'
    params['digits'] 	= '5.0f'
    params['limits'] 	= '0,0,0,0'
    params['orientation'] = 'v'
    params['clabel'] 	= ' '
    params['scalex'] 	= '1'
    params['scaley'] 	= '1'
    params['scalez'] 	= '1'
    params['xlabel'] 	= 'X (m)'
    params['ylabel'] 	= 'Y (m)'
    params['climits'] 	= '0,0'
    params['stations'] 	= '0'
    params['stations_size'] 	= '100'
    params['stations_color'] 	= 'r'
    params['stationfile'] = '0'
    params['bgcolor'] 	= 'white'
    params['north'] 	= '0'
    params['gridaux'] 	= '0'
    params['frame'] 	= '0.05,0.95,0.05,0.95'

#    VecParams
    params['vectors'] 	= '0' 
    params['vecfile'] 	= 'average.out'
    params['vecfactor'] = '1000.'
    params['vlimits'] 	= '0,0'
    params['vecpalette'] = '5'
    params['cveclabel'] = 'Velocity (m/s)'
    params['vecdigits'] = '5.0f'
    params['vecorientation'] = 'v'

    fid		= open(filein,'r')
    data	= fid.readlines()
    
    print '\n --- Program viewgrid ---\n'
    print ' parameters in the input file:'     
    for line in data:
        for j in params.keys():
            if (line[0]!="#") and (j == line.split("=")[0].strip(' \t\n\r')):
                if "!" in line:
                    line_aux=line.split("!")[0]
                    key,val=line_aux.split("=")[0].strip(' \t\n\r').lower(),line_aux.split("=")[1].strip(' \t\n\r')
                    params[key]=val
                else:
                    key,val=line.split("=")[0].strip(' \t\n\r').lower(),line.split("=")[1].strip(' \t\n\r')
                    params[key]=val
                print '    '+key+': '+params[key]
    print '\n --- End of parameter list ---\n'
    return params

def set_palette(palette_option):
    # Choose colour palette (parname: palette or vecpalette)
    # The sign of palette_option determines wether the palette is reversed or not
    # when adding a palette, make sure both are added

    # negative palette_option (reversed palettes)
    if (palette_option== -1.0) :
        elmin,elmax=z.min(),z.max()
        palette,levs,l,zticks = morpho_cmap(elmin,elmax,elmin,elmax,Out_zero=0.,dLev=2,dTick=2,reverse=True)
    elif palette_option == -2 :
        palette = plt.cm.jet_r
    elif palette_option == -3 :
        palette = plt.cm.terrain_r
    elif palette_option == -4 :
        palette = plt.cm.Greys_r
    elif palette_option == -5 :
        palette = plt.cm.winter_r
    elif palette_option == -6 :
        palette = plt.cm.Reds_r
    elif palette_option == -7 :
        palette = plt.cm.RdYlGn_r
    elif palette_option == -8 :
        palette = plt.cm.Blues_r

    # positive palette_option (direct palettes)
    elif palette_option == 1 :
        elmin,elmax=z.min(),z.max()
        palette,levs,l,zticks = morpho_cmap(elmin,elmax,elmin,elmax,Out_zero=0.,dLev=2,dTick=2,reverse=False)
    elif palette_option == 2 :
        palette = plt.cm.jet
    elif palette_option == 3 :
        palette = plt.cm.terrain
    elif palette_option == 4 :
        palette = plt.cm.Greys
    elif palette_option == 5 :
        palette = plt.cm.winter
    elif palette_option == 6 :
        palette = plt.cm.Reds
    elif palette_option == 7 :
        palette = plt.cm.RdYlGn
    elif palette_option == 8 :
        palette = plt.cm.Blues
    else:
        sys.exit('Inadequate value for palette')
    return palette

##########################################################################################
##########################################################################################
### main program
if len(sys.argv)!=2:
    print"""
    viewGridBat.py shows a gr3 file 
    Format: ./viewGridBat.py <filein>
	    filein is the parameter file with the user's choices
    """
    sys.exit("Error")

# read inputs
args=[]
for i in xrange(len(sys.argv)):
    args.append(sys.argv[i])
params = read_parms(args[1])

# read grid (parname: grid)
filein = params['grid']
[filename,elem,nodes,xyz,npel,ncon,bnd]=read_mgrid(filein)
x=xyz[:,0]
y=xyz[:,1]
z=xyz[:,2]
triangles=ncon[:]-1

# Scale coordinates (parnames: scalex, scaley and scalez)
x = x*float(params['scalex'])
y = y*float(params['scaley'])
z = z*float(params['scalez'])

# create figure. Set background color (parname: bgcolor) and frame (parname: frame)
fig=plt.figure()
framelims = eval('['+params['frame']+']')
plt.subplots_adjust(left=framelims[0],right=framelims[1],bottom=framelims[2],top=framelims[3],wspace=None, hspace=None)
plt.rcParams['axes.facecolor'] = params['bgcolor']

# plot boundaries (first first outside boundaries, then islands)
for i in bnd:
    ibnd=i[:,0]
    if i[0][1]==0:
        plt.plot(x[ibnd-1],y[ibnd-1],'k')
    else:
        plt.plot(x[ibnd-1],y[ibnd-1],'k')

# plot axes (parnames: xlabel and ylabel)
plt.axis([x.min(),x.max(),y.min(),y.max()])

plt.xlabel(params['xlabel'])
plt.ylabel(params['ylabel'])

# turn on/off the grid (parname: showgrid)
if params['showgrid'] != '0':
    alpha = float(params['showgrid'])
    plt.triplot(x, y, triangles,alpha=alpha,linewidth=0.2)

# Choose colour palette (parname: palette)
palette= set_palette(float(params['palette']))

# Define limits of the colour palette (parname: climits)
limits = eval('['+params['climits']+']')
if limits == [0,0]:
    levs=np.array([z.min(),z.max()])
else:
    levs=limits
levs_new=interpol1d(256,y=levs)

levs_aux=levs
# number of digits in legend (parname: digits)
text_levs=text_labels(array_in=levs_aux,form=params['digits'])

# contours
contours=plt.tricontourf(x, y,triangles,z,levs_new,cmap=palette,norm=colors.BoundaryNorm(levs_new, ncolors=256, clip = False), origin='lower',antialiased=False)

# colour bar (parnames: orientation, clabel and digits)
if params['orientation'] == 'v':
    cbar=plt.colorbar(contours,ticks=levs_aux,cmap = palette,orientation='vertical',format="%"+params['digits'][1:])
    cbar.ax.invert_yaxis()			   # deeper colors in the bottom
    cbar.ax.set_xticklabels(text_levs,rotation=0)  # vertically oriented colorbar
    cbar.set_label(params['clabel'])
elif params['orientation'] == 'h':
    cbar=plt.colorbar(contours,ticks=levs_aux,cmap = palette,orientation='horizontal',format="%"+params['digits'][1:])
    cbar.ax.invert_xaxis()			   # deeper colors on the left 
    cbar.ax.set_xticklabels(text_levs,rotation=45) # horizontally oriented colorbar
    cbar.set_label(params['clabel'])
plt.axis('scaled')


# vectors
if params['vectors'] =='1':
    data=np.loadtxt(params['vecfile'])
    X,Y,U,V=data[:,0]*float(params['scalex']),data[:,1]*float(params['scaley']),data[:,2],data[:,3]
    Mag=np.hypot(U,V)

    np.seterr(divide='ignore', invalid='ignore')
    U2,V2=U/Mag,V/Mag
    U2 = np.nan_to_num(U2)
    V2 = np.nan_to_num(V2)

    # Define limits of the colour palette (parname: vlimits)
    limits = eval('['+params['vlimits']+']')
    if limits == [0,0]:
        levsVec=np.linspace(Mag.min(),Mag.max(),11)
    else:
        levsVec=limits

    # Choose colour palette (parname: vecpalette)
    vecpalette= set_palette(float(params['vecpalette']))

    Mag = np.clip(Mag,0,levsVec[len(levsVec)-1])
#    Vels=plt.quiver(X,Y,U2,V2,Mag,cmap=vecpalette, scale_units='xy', scale=np.float(params['vecfactor']), width = 0.005, linewidth=0.4)
    Vels=plt.quiver(X,Y,U2,V2,Mag,cmap=vecpalette, scale_units='xy', scale=np.float(params['vecfactor']))
    #qk = plt.quiverkey(Vels, 0.4, 0.95, 1, r'$1 {m}.{s}^{-1}$', labelpos='E',coordinates='figure')
    levsVec_new=interpol1d(256,y=levsVec)
    text_levsVec=text_labels(array_in=levsVec)

    # number of digits in legend (parname: vecdigits)
    text_levsVec=text_labels(array_in=levsVec,form=params['vecdigits'])

    if params['vecorientation'] == 'v':
        cbar2=plt.colorbar(Vels,ticks=levsVec,cmap = vecpalette,orientation='vertical',format="%"+params['vecdigits'][1:])
        cbar2.ax.set_xticklabels(text_levsVec,rotation=0)  # vertically oriented colorbar
        cbar2.set_label(params['cveclabel'])
    elif params['vecorientation'] == 'h':
        cbar2=plt.colorbar(Vels,ticks=levsVec,cmap = vecpalette,orientation='horizontal',format="%"+params['vecdigits'][1:])
        cbar2.ax.set_xticklabels(text_levsVec,rotation=45) # horizontally oriented colorbar
        cbar2.set_label(params['cveclabel'])


# Choose domain (parname: limits)
coor = eval('['+params['limits']+']')
if coor == [0,0,0,0]:
    coor = [x.min(),x.max(),y.min(),y.max()]
plt.axis(coor)

# draw a mixed tris-quads grid (parname: gridaux)
if params['gridaux'] != '0':
    [filename,elem,nodes,xyz,npel,ncon,bnd]=read_mgrid(params['gridaux'])
    x=xyz[:,0]*float(params['scalex'])
    y=xyz[:,1]*float(params['scaley'])
    for i in range (0,elem):
        if npel[i] == 3:
    	    xpol = [x[ncon[i][0]-1],x[ncon[i][1]-1],x[ncon[i][2]-1],x[ncon[i][0]-1]]
    	    ypol = [y[ncon[i][0]-1],y[ncon[i][1]-1],y[ncon[i][2]-1],y[ncon[i][0]-1]]
        elif npel[i] == 4:
    	    xpol = [x[ncon[i][0]-1],x[ncon[i][1]-1],x[ncon[i][2]-1],x[ncon[i][3]-1],x[ncon[i][0]-1]]
    	    ypol = [y[ncon[i][0]-1],y[ncon[i][1]-1],y[ncon[i][2]-1],y[ncon[i][3]-1],y[ncon[i][0]-1]]
        ax = fig.add_subplot(111)
        ax.plot(xpol,ypol,color='black',alpha=0.5)

# Draw north arrow (parname: north)
if params['north'] == '1':
    ax=plt.subplot(111)
    NorthArrow(ax,xc=0.08,yc=0.90)
elif params['north'] == '-1':
    ax=plt.subplot(111)
    NorthArrow_i(ax,xc=0.08,yc=0.90)

# Include stations (parnames: stations, stationfile)
if params['stations'] != '0':
    filename,nodes,nxyz = read_bpt(params['stations'])
    xp = nxyz[:,1]*float(params['scalex'])
    yp = nxyz[:,2]*float(params['scaley'])
    plt.scatter(xp,yp,s=float(params['stations_size']),c=params['stations_color'],alpha=1,linewidths=0)
    if params['stationfile'] != '0':
	nsta,sta = read_stations(params['stationfile'])
	if nsta != nodes:
	    print ' Number of stations in '+params['stations']+' and '+params['stationfile']+ 'differs'
	    exit
	stations = sta[:,0]
	for i in range(nsta):
	    dx = float(sta[i,1])*float(params['scalex'])
	    dy = float(sta[i,2])*float(params['scaley'])
	    plt.text(xp[i]+dx,yp[i]+dy,stations[i],color=params['stations_color'])



# Show or save the figure (parname: savefig). The extension of the output file determines the output format
# accepted formats: emf, eps, jpeg, jpg, pdf, pgf, png, ps, raw, rgba, svg, svgz, tif, tiff
if params['savefig']=='0':
	plt.show()
else:
	plt.savefig(params['savefig'], dpi=600)
	plt.clf()
	print params['savefig']+' saved!!!'

