function scores=compute_skillmetrics2(t_min,t_max,d_min,d_max,data,mod,plot_flag);
%function scores=[bias rmse mae wilmot cc var_d var_m nrmse err_max]=compute_skillmetrics2(t_min,t_max,d_min,d_max,data,mod,plot_flag);
%Difference from compute_skillmetrics: inputs are data not file names.

%Compute skill metrics from two time series (model and data, whose times may or may not overlap; time in any units)
%Inputs: two datasets (data and mod with format: [time value]) - both
%        may have nan in 'value'; a flag indicating if you want to plot the comparison or not (1 for yes).
%        d_m* are used to filter data further.
%        t_m*: min/max times 
%Outputs: rmse wilmot cc (correlation) and variance of data and model etc

mod2=interp1(mod(:,1),mod(:,2),data(:,1));
index=find(~isnan(mod2) & ~isnan(data(:,2)) & data(:,2)>d_min & data(:,2)<d_max & data(:,1)>=t_min & data(:,1)<=t_max);
mod3=mod2(index);
data3=data(index,:);
nfinal=length(mod3);

if(plot_flag==1)
  close all;
  plot(data3(:,1),data3(:,2),'r',data3(:,1),mod3,'b'); %,mod(:,1),mod(:,2),'g--');
end

aa=corrcoef(mod3,data3(:,2));
cc=aa(1,2);

rmse=sqrt(sum((mod3-data3(:,2)).^2)/nfinal);
mae=sum(abs(mod3-data3(:,2)))/nfinal;

data_mean=mean(data3(:,2));
mod_mean=mean(mod3);
bias=mod_mean-data_mean;
wilmot=1-sum((mod3-data3(:,2)).^2)/sum((abs(mod3-data_mean)+abs(data3(:,2)-data_mean)).^2);

%Variance
var_d=sum((data3(:,2)-data_mean).^2)/nfinal;
var_m=sum((mod3-mod_mean).^2)/nfinal;

%Normalized RMSE against range of obs, mod
d_range=max(data3(:,2))-min(data3(:,2));
m_range=max(mod3)-min(mod3);
rangemax=max([data3(:,2) mod3])-min([data3(:,2) mod3]);
nrmse=rmse/max([d_range m_range]);

%Error in max values
dmax=max(data3(:,2));
mmax=max(mod3);
maxmax=max([max(abs(data3(:,2))) max(abs(mod3))]);
err_max=abs(mmax-dmax)/maxmax; %max([dmax mmax]); %(max(mod3)-max(data3(:,2)))/max(data3(:,2))

scores=[bias rmse mae wilmot cc var_d var_m nrmse err_max];
end
